import type { Metadata } from "next";
import "./globals.css";
import localFont from "next/font/local";
import ReactQueryProvider from "@/shared/providers/ReactQueryProvider";

//no-cash
export const revalidate = 0;
export const dynamic = "force-dynamic";

const peyda = localFont({
  src: [
    {
      path: "./../assets/fonts/Peyda/fonts/woff/PeydaWebFaNum-Light.woff",
      weight: "100",
      style: "normal",
    },
    {
      path: "./../assets/fonts/Peyda/fonts/woff/PeydaWebFaNum-ExtraLight.woff",
      weight: "200",
      style: "normal",
    },
    {
      path: "./../assets/fonts/Peyda/fonts/woff/PeydaWebFaNum-Thin.woff",
      weight: "300",
      style: "normal",
    },
    {
      path: "./../assets/fonts/Peyda/fonts/woff/PeydaWebFaNum-Regular.woff",
      weight: "400",
      style: "normal",
    },
    {
      path: "./../assets/fonts/Peyda/fonts/woff/PeydaWebFaNum-Medium.woff",
      weight: "500",
      style: "normal",
    },
    {
      path: "./../assets/fonts/Peyda/fonts/woff/PeydaWebFaNum-SemiBold.woff",
      weight: "600",
      style: "normal",
    },
    {
      path: "./../assets/fonts/Peyda/fonts/woff/PeydaWebFaNum-Bold.woff",
      weight: "700",
      style: "normal",
    },
    {
      path: "./../assets/fonts/Peyda/fonts/woff/PeydaWebFaNum-ExtraBold.woff",
      weight: "800",
      style: "normal",
    },
    {
      path: "./../assets/fonts/Peyda/fonts/woff/PeydaWebFaNum-Black.woff",
      weight: "900",
      style: "normal",
    },
  ],
  display: "swap",
  variable: "--font-peyda",
});

export const metadata: Metadata = {
  title: "arta-mdf",
  description: "Generated by create next app",
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="fa" className={`${peyda.variable} `}>
      <body className={`${peyda.className}`} dir="rtl">
        <ReactQueryProvider>{children}</ReactQueryProvider>
      </body>
    </html>
  );
}
