"use client";
import DropdownMenu from "@/shared/components/dropdown/DropdownMenu";
import LinkCM from "@/shared/components/link";
import Modal from "@/shared/components/modal";
import { Wrapper } from "@/shared/components/wrapper";
import { Bar } from "@/shared/icons/Bar";
import Logo from "@/shared/icons/Logo";
import Link from "next/link";
import { useEffect, useState } from "react";

type Props = {};

function Header({}: Props) {
  const [scrolled, setScrolled] = useState(false);
  const [menuOpen, setMenuOpen] = useState(false);

  useEffect(() => {
    const handleScroll = () => {
      setScrolled(window.scrollY > 50);
    };

    window.addEventListener("scroll", handleScroll);

    return () => {
      window.removeEventListener("scroll", handleScroll);
    };
  }, []);
  return (
    <>
      <header
        className={`sticky z-40 top-0 ${
          scrolled ? "bg-white" : "bg-transparent"
        }`}
      >
        <Wrapper
          className={`flex justify-between items-center py-4 lg:py-6 mb-5 lg:mb-0 ${
            scrolled ? "text-gray-900" : "text-white"
          }`}
        >
          <section className="hidden lg:flex items-center justify-center gap-8 w-1/3">
            <Link href="/">صفحه اصلی</Link>
            <Link href="/login">راهنمای بارنامه</Link>
          </section>
          <section className="hidden lg:block">
            <Logo fill={`${scrolled ? "var(--color-primary-main)" : "#fff"}`} />
          </section>
          <section className="lg:hidden">
            <Logo
              fill={`${scrolled ? "var(--color-primary-main)" : "#fff"}`}
              width="146"
              height="16"
            />
          </section>
          <section className="flex items-center justify-end sm:w-1/3 gap-5 sm:gap-8">
            <Link href="tel:۰۲۱۸۵۸۸" className="hidden lg:inline-block">
              ۰۲۱-۸۵۸۸
            </Link>
            <Link href="/login" className="w-max">
              ورود / ثبت‌نام
            </Link>
            <LinkCM href="/login" className="hidden lg:Flex">
              ثبت مناقصه
            </LinkCM>
            <button onClick={() => setMenuOpen(true)}>
              <Bar fill={scrolled ? "var(--color-primary-main)" : "#fff"} />
            </button>
          </section>
        </Wrapper>
      </header>

      <Modal
        backdrop
        isOpen={menuOpen}
        onClose={() => setMenuOpen(false)}
        enterFrom="top"
        position="top"
        modalClssName="rounded-none!"
      >
        <Logo fill="var(--color-primary-main)" width="146" height="16" />
        <ul className="mt-8 space-y-5">
          <li>
            <Link href="/">صفحه اصلی</Link>
          </li>
          <li>
            <Link href="/login">راهنمای بارنامه</Link>
          </li>
          <li>
            <Link href="tel:۰۲۱۸۵۸۸">۰۲۱-۸۵۸۸</Link>
          </li>
          <li className="flex justify-between items-center">
            <Link href="/login" className="w-max">
              ورود / ثبت‌نام
            </Link>
            <LinkCM href="/">ثبت مناقصه</LinkCM>
          </li>
        </ul>
      </Modal>
    </>
  );
}

export default Header;
