import LinkCM from "@/shared/components/link";
import { Typography } from "@/shared/components/typography";
import { ChevronLeft } from "@/shared/icons/ChevronLeft";
import Image from "next/image";

type Props = {};

function HeroSection({}: Props) {
  return (
    <section className="hero-section h-[842px] flex flex-col justify-end gap-10 items-center pb-40">
      <Image
        src="/light-blonde.png"
        alt=""
        width={381}
        height={183}
        className="w-[217px] h-[105px] sm:w-[381px] sm:h-[183px]"
      />
      <Typography
        as="p"
        variant="H5R"
        className="text-white text-center max-w-[429px] leading-10"
      >
        برای فروش و ثبت مناقصه کافیست وارد حساب کاربری شوید یا ثبت نام کنید و
        چوب خود را در کمتر از یک ساعت بفروشید
      </Typography>
      <LinkCM href="" className="group">
        ثبت مناقصه و فروش چوب
        <span className="flex items-center">
          <span className="inline-block w-4 h-0.5 bg-white -ml-1 transition-all duration-300 group-hover:w-7"></span>
          <ChevronLeft />
        </span>
      </LinkCM>
    </section>
  );
}

export default HeroSection;
