import LinkCM from "@/shared/components/link";
import { Typography } from "@/shared/components/typography";
import { Wrapper } from "@/shared/components/wrapper";
import { ChevronLeft } from "@/shared/icons/ChevronLeft";

type Props = {};

function IntroSection({}: Props) {
  return (
    <section className="h-[742px] mask">
      <Wrapper className="h-full flex flex-col justify-center gap-5">
        <Typography
          as="h2"
          variant="H1B"
          className="leading-16 2xl:leading-[75px] text-secondary-text"
        >
          فروش چوب <br /> بهترین قیمت، بدون واسطه
        </Typography>
        <Typography variant="H5R" as="p" className="sm:w-1/2! block">
          توضیحات در این بخش نمایش داده می شود تا کاربر راحت متوجه فرآیند
          شودتوضیحات در این بخش نمایش داده می شود تا کاربر راحت متوجه فرآیند
          شود. توضیحات در این بخش نمایش داده می شود تا کاربر راحت متوجه فرآیند
          شودتوضیحات در این بخش نمایش داده می شود تا کاربر راحت متوجه فرآیند
          شودتوضیحات در این بخش نمایش داده می شود تا کاربر راحت متوجه فرآیند
        </Typography>
        <div className="flex flex-wrap sm:flex-nowrap gap-5 mt-5">
          <LinkCM href="" className="group">
            ثبت مناقصه و فروش چوب
            <span className="flex items-center">
              <span className="inline-block w-4 h-0.5 bg-white -ml-1 transition-all duration-300 group-hover:w-7"></span>
              <ChevronLeft />
            </span>
          </LinkCM>
          <LinkCM href="" className="group" variant="outline" color="white">
            ساخت حساب کاربری
            <span className="flex items-center">
              <span className="inline-block w-4 h-0.5 bg-secondary-main -ml-1 transition-all duration-300 group-hover:w-7"></span>
              <ChevronLeft fill="var(--color-secondary-main)" />
            </span>
          </LinkCM>
        </div>
      </Wrapper>
    </section>
  );
}

export default IntroSection;
