import Link from "next/link";
import React, { AnchorHTMLAttributes } from "react";

type LinkProps = {
  children: React.ReactNode;
  className?: string;
  color?: "primary" | "success" | "danger" | "white" | "warning";
  variant?: "text" | "contained" | "outline" | "link";
  href: string;
  size?: "icon" | "sm-icon" | "md" | "sm" | "lg";
} & AnchorHTMLAttributes<HTMLAnchorElement>;

function LinkCM({
  children,
  className = "",
  color = "primary",
  variant = "contained",
  href = "/",
  size = "md",
  ...rest
}: LinkProps) {
  const variantClasses = {
    primary:
      variant === "contained"
        ? "bg-primary-main text-white hover:bg-primary-hover border-primary-main hover:border-primary-hover"
        : variant === "outline"
        ? "text-primary-main bg-transparent border-primary-main"
        : variant === "text"
        ? "bg-transparent text-primary-main border-white"
        : "bg-transparent underline text-primary-main border-white",
    danger:
      variant === "contained"
        ? "bg-red-600 text-white hover:bg-red-500 border-red-600 hover:border-red-500"
        : variant === "outline"
        ? "text-red-600 bg-white border-red-600"
        : variant === "text"
        ? "bg-white text-red-600 border-white"
        : "bg-white underline text-red-600 border-white",
    success: "bg-green-500 text-white hover:bg-green-600",
    warning: "text-yellow-800 border-0",
    white:
      variant === "contained"
        ? "bg-white text-gray-800"
        : variant === "outline"
        ? "text-dark-blue-800 bg-transparent border-dark-blue-800"
        : variant === "text"
        ? "bg-white text-dark-blue-800 border-white"
        : "bg-white underline text-dark-blue-800 border-white",
  };

  const sizeClasses = {
    icon: "size-[52px]",
    "sm-icon": "size-8",
    sm: "h-9",
    md: "h-10",
    lg: "h-11",
  };

  const btnClass = `flex justify-center ${
    variant === "text" ? "" : "border"
  } items-center gap-2 ${size === "sm-icon" ? "p-2" : "px-4"} rounded-[50px] ${
    variantClasses[color]
  } ${sizeClasses[size]} ${className}`;

  return (
    <Link href={href} className={btnClass} {...rest}>
      {children}
    </Link>
  );
}

export default LinkCM;
