"use client";
import { ArrowRight2 } from "iconsax-react";
import { useRouter } from "next/navigation";
import React from "react";
import { Typography } from "../typography";

interface PageHeaderProps {
  title: string | React.ReactNode;
  backBtn?: boolean;
}

const PageHeader = (props: PageHeaderProps) => {
  const { title, backBtn } = props;
  const router = useRouter();

  return (
    <div className="flex items-center">
      {backBtn && (
        <button onClick={() => router.back()} className="cursor-pointer">
          <ArrowRight2 size={30} color="var(--color-gray-1000)" />
        </button>
      )}
      <Typography as="h1" variant="H5M">
        {title}
      </Typography>
    </div>
  );
};

export default PageHeader;
