"use client";
import React from "react";

interface StepperProps {
  currentStep: number;
  steps: string[];
}

const Stepper: React.FC<StepperProps> = ({ currentStep, steps }) => {
  return (
    <div className="flex items-center justify-between w-full max-w-2xl mx-auto">
      {steps.map((step, index) => {
        const isActive = currentStep === index + 1;
        const isCompleted = currentStep > index + 1;

        return (
          <React.Fragment key={index}>
            <div className="flex flex-col items-center w-max relative">
              <p
                className={`
                  mt-2 text-sm font-medium
                  ${
                    isCompleted || isActive ? "text-green-700" : "text-gray-700"
                  }
                `}
              >
                {step}
              </p>

              {index < steps.length - 1 && (
                <div
                  className={`
                    absolute top-5 right-[calc(50%+50px)] w-[40%] min-[350px]:w-[40px] min-[360px]:w-[55px] min-[380px]:w-[60px] min-[420px]:w-[80px] min-[450px]:w-[100px] min-[500px]:w-[120px] min-[550px]:w-[150px] sm:w-48 h-0.5 
                    ${isCompleted ? "bg-green-600" : "bg-gray-600"}
                  `}
                />
              )}
            </div>
          </React.Fragment>
        );
      })}
    </div>
  );
};

export default Stepper;
