export const calculateTimeAgo = (dateString: string): string => {
  if (!dateString) {
    console.warn("Empty date string provided to calculateTimeAgo");
    return "نامعتبر";
  }

  const date = new Date(dateString);
  if (isNaN(date.getTime())) {
    console.warn(`Invalid date format: ${dateString}`);
    return "نامعتبر";
  }

  const diffMs = Date.now() - date.getTime();
  if (diffMs < 0) {
    console.warn(`Date is in the future: ${dateString}`);
    return "نامعتبر";
  }

  const totalMinutes = Math.floor(diffMs / 60000);
  if (totalMinutes === 0) return "همین حالا";

  const days = Math.floor(totalMinutes / (60 * 24));
  const hours = Math.floor((totalMinutes % (60 * 24)) / 60);
  const minutes = totalMinutes % 60;

  const parts = [];
  if (days > 0) parts.push(`${days} روز`);
  if (hours > 0) parts.push(`${hours} ساعت`);
  if (minutes > 0) parts.push(`${minutes} دقیقه`);
  return parts.length > 0 ? `${parts.join(" و ")} پیش` : "نامعتبر";
};
