type Props = {
  width?: string;
  height?: string;
  fill?: string;
};
export function Bar({ width = "30", height = "16", fill = "#fff" }: Props) {
  return (
    <svg
      width={width}
      height={height}
      viewBox="0 0 30 16"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path d="M20 0H0V2H20V0Z" fill={fill} />
      <path d="M30 7H0V9H30V7Z" fill={fill} />
      <path d="M30 14H10V16H30V14Z" fill={fill} />
    </svg>
  );
}
