type Props = {
  width?: string;
  height?: string;
  fill?: string;
};
export function ChevronLeft({
  width = "5",
  height = "10",
  fill = "#fff",
}: Props) {
  return (
    <svg
      width={width}
      height={height}
      viewBox="0 0 5 10"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <g clipPath="url(#clip0_64_15076)">
        <path
          d="M4.97561 0C4.97561 3.33333 1.65854 4.72222 0 5C1.65854 5.27778 4.97561 6.66667 4.97561 10"
          stroke={fill}
          strokeWidth="1.75"
        />
      </g>
      <defs>
        <clipPath id="clip0_64_15076">
          <rect width="4.97561" height="10" fill={fill} />
        </clipPath>
      </defs>
    </svg>
  );
}
