type Props = {
  width?: string;
  height?: string;
  fill?: string;
};
function Logo({ width = "218", height = "24", fill = "#fff" }: Props) {
  return (
    <svg
      width={width}
      height={height}
      viewBox="0 0 218 24"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <g clipPath="url(#clip0_3_2005)">
        <path
          d="M9.32241 2.05371C6.69292 10.2365 4.55365 17.0117 2.30462 23.9999H0L7.56796 0.367966H19.5427L27.1525 23.9999H20.8447L19.2193 18.9624H5.3462L5.77899 17.4066H18.6485L13.9611 2.05371H9.32241Z"
          fill={fill}
        />
        <path
          d="M59.6592 0.367966H86.8113V2.15876H76.264V23.9999H70.1652V2.15876H59.6592V0.367966Z"
          fill={fill}
        />
        <path
          d="M97.1857 2.05371C94.5562 10.2365 92.417 17.0117 90.168 23.9999H87.8633L95.4312 0.367966H107.406L115.016 23.9999H108.708L107.083 18.9624H93.2094L93.642 17.4066H106.512L101.824 2.05371H97.1857Z"
          fill={fill}
        />
        <path
          d="M52.5513 19.5169V19.4173C52.5513 19.1597 52.5375 18.8556 52.5098 18.4928C52.4818 18.1357 52.4401 17.7554 52.3914 17.3518C52.3358 16.9535 52.2659 16.544 52.1825 16.1341C52.1058 15.7246 52.0083 15.3384 51.9109 14.9812C51.8064 14.6303 51.6951 14.3198 51.5628 14.0567C51.4374 13.7932 51.2982 13.6175 51.1449 13.5242C50.7899 13.2959 49.4046 13.1263 46.9884 13.0092C45.7631 12.9565 44.6842 12.9156 43.7514 12.8804C42.8113 12.8512 41.997 12.8336 41.3076 12.8336H37.5549V22.2498V23.9999H31.4561V0.367966H41.2935C42.5609 0.367966 43.9324 0.391398 45.4012 0.432389C46.8703 0.479236 48.4787 0.537792 50.219 0.613918C51.9597 0.707611 53.3449 0.807151 54.3755 0.923902C55.3988 1.03516 56.0881 1.1757 56.4432 1.33344C56.7982 1.50326 57.1114 1.77262 57.3828 2.12947C57.6547 2.49253 57.8844 2.90793 58.0653 3.3936C58.2532 3.87342 58.3855 4.38874 58.476 4.94468C58.5665 5.49476 58.6082 6.0507 58.6082 6.61249C58.6082 7.16257 58.5665 7.71265 58.476 8.2686C58.3855 8.81868 58.2532 9.33399 58.0653 9.80795C57.8844 10.2819 57.6547 10.7031 57.3828 11.0603C57.1046 11.423 56.7912 11.6807 56.4362 11.8385C56.4151 11.8619 56.3876 11.8912 56.3596 11.9204C56.332 11.9497 56.2902 11.9614 56.2343 11.9614C56.4919 12.0083 56.7357 12.1722 56.9515 12.4534C57.1674 12.7282 57.3691 13.085 57.5431 13.5125C57.7241 13.9396 57.8774 14.4253 58.0166 14.9519C58.149 15.4844 58.2674 16.0174 58.351 16.5557C58.4415 17.0941 58.504 17.6149 58.5458 18.1181C58.5876 18.6217 58.6082 19.0547 58.6082 19.4232V23.9999H52.5513V19.5169ZM41.3076 2.15876H37.5549V11.0077H41.3076C41.997 11.0077 42.8113 10.9959 43.7514 10.9784C44.6842 10.955 45.7631 10.9198 46.9884 10.8671C48.228 10.8086 49.1815 10.7383 49.864 10.6505C50.5392 10.5688 50.9709 10.4751 51.1449 10.3698C52.0851 9.80795 52.5513 8.56138 52.5513 6.61834C52.5513 4.69873 52.0851 3.4346 51.1449 2.83182C50.8179 2.61516 49.4323 2.44569 46.9884 2.33443C45.7631 2.27587 44.6842 2.22903 43.7514 2.19975C42.8113 2.17047 41.997 2.15876 41.3076 2.15876Z"
          fill={fill}
        />
        <path
          d="M153.011 12.6544C151.785 12.6017 150.706 12.5606 149.773 12.5256C148.833 12.4963 148.018 12.4787 147.329 12.4787H143.577V21.8953V23.645H137.478V0.0134735H147.315C148.582 0.0134735 149.954 0.0368968 151.424 0.0775217C152.892 0.124369 154.501 0.182925 156.241 0.259052C157.982 0.352744 159.367 0.452292 160.397 0.56941C161.42 0.680304 162.11 0.820842 162.465 0.97895C162.821 1.14877 163.133 1.41777 163.405 1.77498C163.676 2.13768 163.906 2.55307 164.087 3.0391C164.275 3.51892 164.408 4.03386 164.498 4.58979C164.589 5.13987 164.631 5.69582 164.631 6.25762C164.631 6.8077 164.589 7.35814 164.498 7.91372C164.408 8.46417 164.275 8.97912 164.087 9.45308C163.906 9.92703 163.676 10.3486 163.405 10.7055C162.819 11.4678 161.818 12.0769 160.59 12.2621C157.863 12.6727 154.67 12.7456 153.011 12.6544ZM147.329 1.80424H143.577V10.6528H147.329C148.018 10.6528 148.833 10.6411 149.773 10.6235C150.706 10.6001 151.785 10.565 153.011 10.5122C154.249 10.4537 155.204 10.3838 155.885 10.2959C156.561 10.214 156.993 10.1203 157.167 10.0149C158.106 9.45307 158.573 8.2065 158.573 6.26347C158.573 4.34384 158.106 3.07972 157.167 2.47731C156.84 2.26064 155.454 2.09082 153.011 1.97956C151.785 1.921 150.706 1.87416 149.773 1.84525C148.833 1.81597 148.018 1.80424 147.329 1.80424Z"
          fill={fill}
        />
        <path
          d="M173.867 2.05371C171.238 10.2365 169.099 17.0117 166.85 23.9999H164.545L172.113 0.367966H184.088L191.698 23.9999H185.39L183.765 18.9624H169.891L170.324 17.4066H183.194L178.505 2.05371H173.867Z"
          fill={fill}
        />
        <path
          d="M197.835 3.26719C197.987 12.7859 197.891 15.1242 197.891 23.5477L195.885 23.632L195.721 0.0413526L200.969 0L217.936 23.6418L211.822 23.632L198.228 3.26719H197.835Z"
          fill={fill}
        />
        <path
          d="M217.942 0.198044C217.674 8.79697 218.168 16.302 217.936 23.6462L215.905 23.6309L215.176 0.206461L217.942 0.198044Z"
          fill={fill}
        />
      </g>
      <defs>
        <clipPath id="clip0_3_2005">
          <rect width={width} height={height} fill={fill} />
        </clipPath>
      </defs>
    </svg>
  );
}

export default Logo;
