type Props = {
  width?: string;
  height?: string;
  fill?: string;
};
export function Wallet({
  width = "56",
  height = "56",
  fill = "#EACAAC",
}: Props) {
  return (
    <svg
      width={width}
      height={height}
      viewBox="0 0 56 56"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        opacity="0.4"
        fillRule="evenodd"
        clipRule="evenodd"
        d="M40.8815 35.4012C36.6185 35.4012 33.1511 31.9338 33.1511 27.6732C33.1511 23.4102 36.6185 19.9406 40.8815 19.9406H50.7048C48.6561 10.4813 42.1391 6.90894 28.5848 6.90894C11.7008 6.90894 5.71582 12.4296 5.71582 27.9998C5.71582 43.5725 11.7008 49.0908 28.5848 49.0908C42.4495 49.0908 48.9548 45.3575 50.8401 35.4012H40.8815Z"
        fill={fill}
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M27.7703 20.1624H18.2969C17.3309 20.1624 16.5469 19.3784 16.5469 18.4124C16.5469 17.4464 17.3309 16.6624 18.2969 16.6624H27.7703C28.7363 16.6624 29.5203 17.4464 29.5203 18.4124C29.5203 19.3784 28.7363 20.1624 27.7703 20.1624Z"
        fill={fill}
      />
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        d="M40.8807 31.9011C38.5497 31.9011 36.6504 30.0041 36.6504 27.6731C36.6504 25.3398 38.5497 23.4404 40.8807 23.4404H51.2314C51.3691 24.8614 51.4507 26.3618 51.4507 27.9998C51.4507 29.3881 51.3854 30.6691 51.2874 31.9011H40.8807ZM42.9576 27.5329C42.9576 28.4989 42.1736 29.2829 41.2076 29.2829C40.2416 29.2829 39.4576 28.4989 39.4576 27.5329C39.4576 26.5669 40.2416 25.7829 41.2076 25.7829C42.1736 25.7829 42.9576 26.5669 42.9576 27.5329Z"
        fill={fill}
      />
    </svg>
  );
}
